/* ============ */
/* gengapda.c	*/
/* ============ */
#include <miscdefs.h>
#include <gapdefs.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/* ==================================================================== */
/* GenGapData - Generates Data Relating to One Gap			*/
/* ==================================================================== */
/* -------------------------------------------------------------------- */
/* This code reflects the algorithm given by D. E. Knuth, The Art of	*/
/* Computer Programming, Vol. 2, Seminumerical Algorithms, Second Ed.,	*/
/* Addison-Wesley, Reading (1981), pp. 60-61, Algorithm G, steps G2-G4.	*/ 
/* -------------------------------------------------------------------- */
UINT
GenGapData(GAP_DATA_STRU * GapData)
{
    int     Next, GapSize, NumGen;

    GapSize = 0;
    NumGen  = 0;

    do
    {
	Next = GapData->RandFun();

	++NumGen;

	if ((UINT)Next >= GapData->LoGapInt && (UINT)Next < GapData->HiGapInt)
	{
	    break;
	}
	++GapSize;
    }
    while (NumGen <= GapData->MaxGenPerGap);

    if (NumGen <= GapData->MaxGenPerGap)
    {
	GapData->CallStatusOK = TRUE;
    }
    else
    {
	GapData->CallStatusOK = FALSE;

	fprintf(stderr,
	    "GenGapData(): Failed to Detect a Gap\n");
    }

    return(GapSize);
}
